﻿using Microsoft.Xrm.Sdk.Query;
using System.Collections.Generic;
using System.Linq;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.VideoVisit.Mappers;
using VA.TMP.Integration.VIMT.VideoVisit.StateObject;
using VA.TMP.OptionSets;
using VIMT.VideoVisit.Messages;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.VideoVisit.PipelineSteps.Delete
{
    /// <summary>
    /// Delete Appointment step.
    /// </summary>
    public class MapAppointmentStep : FilterBase<VideoVisitDeleteStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(VideoVisitDeleteStateObject state)
        {
            state.CancelAppointmentRequest = new VIMTTmpCancelAppointmentRequest
            {
                OrganizationName = state.OrganizationName,
                UserId = state.UserId,
                LogTiming = false,
                LogSoap = false,
                Debug = false,
                VIMTTmpCancelAppointmentRequestDataInfo = new VIMTTmpCancelAppointmentRequestData
                {
                    Id = state.AppointmentId.ToString(),
                    SourceSystem = "TMP",
                    PatientBookingStatuses = MapCancellations(state),
                    SamlToken = "", // TODO
                }
            };
        }

        private static VIMTTmpPersonBookingStatuses MapCancellations(VideoVisitDeleteStateObject state)
        {
            var statusList = new List<VIMTTmpPersonBookingStatus>();
            var statuses = new VIMTTmpPersonBookingStatuses {};
            var description = string.Empty;
            VIMTTmpStatusCode vimtStatus;
            if (state.WholeApptCanceled)
            {
                if (state.IsGroup)
                {
                    var crmStatus = state.CrmAppointment.cvt_IntegrationBookingStatus.Value;
                    vimtStatus = GetAppointmentCancelStatusCode(crmStatus);
                    description = ((Appointmentcvt_IntegrationBookingStatus)crmStatus).ToString();
                }
                else
                {
                    vimtStatus = GetServiceAppointmentCancelStatusCode(state);
                    description = ((Appointmentcvt_IntegrationBookingStatus)state.ServiceAppointment.StatusCode.Value).ToString();
                }
            }
            else
            {
                // TODO - Temporary
                vimtStatus = VIMTTmpStatusCode.CANCELLED_BY_PATIENT;
                description = Appointmentcvt_IntegrationBookingStatus.PatientCanceled.ToString();

                //var crmstatus = GetIndividualPatientCancellationStatus(state);
                //description = ((Appointmentcvt_IntegrationBookingStatus)crmstatus).ToString();
                //vimtStatus = GetAppointmentCancelStatusCode(crmstatus);
            }

            foreach (var patId in state.CanceledPatients)
            {
                var contact = (Contact)state.OrganizationServiceProxy.Retrieve(Contact.EntityLogicalName, patId, new ColumnSet(true));

                var status = new VIMTTmpStatus
                {
                    Code = vimtStatus,
                    CodeSpecified = true,
                    Reason = VIMTTmpReasonCode.OTHER,
                    ReasonSpecified = true,
                    Description = description
                };
                var patStatus = new VIMTTmpPersonBookingStatus
                {
                    Id = MappingResolvers.PersonIdentifierResolver(state.OrganizationServiceProxy, contact),
                    Status = status
                };
                statusList.Add(patStatus);

            }
            statuses.PersonBookingStatus = statusList.ToArray();
            
            return statuses;
        }

        /// <summary>
        /// Map the TMP status code to the schema status code.
        /// </summary>
        /// <param name="state"></param>
        /// <returns></returns>
        private static VIMTTmpStatusCode GetServiceAppointmentCancelStatusCode(VideoVisitDeleteStateObject state)
        {
            if (state.ServiceAppointment.StatusCode == null) return VIMTTmpStatusCode.CANCELLED_BY_CLINIC;

            switch (state.ServiceAppointment.StatusCode.Value)
            {
                case (int)serviceappointment_statuscode.PatientCanceled: return VIMTTmpStatusCode.CANCELLED_BY_PATIENT;
                case (int)serviceappointment_statuscode.PatientNoShow: return VIMTTmpStatusCode.NO_SHOW;
                case (int)serviceappointment_statuscode.SchedulingError:
                case (int)serviceappointment_statuscode.ClinicCanceled: 
                case (int)serviceappointment_statuscode.TechnologyFailure: return VIMTTmpStatusCode.CANCELLED_BY_CLINIC;
                default: return VIMTTmpStatusCode.CANCELLED_BY_CLINIC;
            }
        }

        //private static int GetIndividualPatientCancellationStatus(VideoVisitDeleteStateObject state)
        //{
        //    using (var srv = new Xrm(state.OrganizationServiceProxy))
        //    {
        //        //cvt_vistaintegrationresultcvt_CancelReason.
        //        var patient = state.CanceledPatients.FirstOrDefault();
        //        var icn = srv.mcs_personidentifiersSet.FirstOrDefault(x => x.mcs_patient.Id == patient && x.mcs_assigningauthority == "USVHA" && x.mcs_identifiertype.Value == (int)mcs_personidentifiersmcs_identifiertype.NationalIdentifier_NI);
        //        var icnString = icn != null ? icn.mcs_identifier : "";
        //        var booking = srv.cvt_vistaintegrationresultSet.FirstOrDefault(vir => vir.cvt_CancelReason != null && vir.cvt_PersonId == icnString);
        //        return booking.cvt_CancelReason.Value;
        //        //return GetAppointmentCancelStatusCode(booking.cvt_CancelReason.Value);
        //    }
        //}

        private static VIMTTmpStatusCode GetAppointmentCancelStatusCode(int crmStatus)
        {
            switch (crmStatus)
            {
                case (int)Appointmentcvt_IntegrationBookingStatus.PatientCanceled: return VIMTTmpStatusCode.CANCELLED_BY_PATIENT;
                case (int)Appointmentcvt_IntegrationBookingStatus.SchedulingError:
                case (int)Appointmentcvt_IntegrationBookingStatus.ClinicCancelled:
                case (int)Appointmentcvt_IntegrationBookingStatus.TechnologyFailure: return VIMTTmpStatusCode.CANCELLED_BY_CLINIC;
                case (int)Appointmentcvt_IntegrationBookingStatus.PatientNoShow: return VIMTTmpStatusCode.NO_SHOW;
                default: return VIMTTmpStatusCode.CANCELLED_BY_PATIENT;
            }
        }
    }
}